﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>

<script runat="server" type="text/C#">

    dynamic __userinfo = HttpContext.Current.Items["user"];                //初始化用户信息
    public static DataRow dr = null;
    public int id = 0;
    public string ordertype = string.Empty;
    int flag = 0;
    bool isLoadPage = true;  //定义页面是否加载

    protected void Page_Load(object sender, EventArgs e)
    {
        CheckUserLogin.Run();
        id = Utils.StrToInt(KSCMS.S("id"));
        ordertype = KSCMS.S("ordertype");

        if (id == 0)
        {
            isLoadPage = false;
            Msg.Alert("Error!");
            return;
        }
        if (KSCMS.S("do") == "dosave")
        {
            isLoadPage = false;
            DoSave();
            return;
        }
        else
        {
            using (DataTable dt = DataFactory.GetDataTable("select top 1 * From KS_CosOrder Where ID=" + id))
            {
                if (dt.Rows.Count > 0)
                {
                    dr = dt.Rows[0];

                    if (__userinfo == null || dr == null)
                    {
                        Msg.AlertDoFun("出错，找不到订单!", "history.back()");
                    }
                    if (__userinfo.UserName != dr["username"].ToString())
                    {
                        Msg.AlertDoFun("对不起，该订单不是您的，不能申请退款！", "history.back()");
                    }
                    else
                    {
                        if (dr["status"].ToString() == "4")
                        {
                            Msg.AlertDoFun("已申请过退款操作， 请等待处理！", "history.back()");
                        }
                        else if (dr["status"].ToString() == "5")
                        {
                            Msg.AlertDoFun("已申请过换货操作， 请等待处理！", "history.back()");
                        }

                        if (dr["DeliverStatus"].ToString() == "1")
                        {
                            Msg.AlertDoFun("对不起，订单已发货，请确认收货后再来申请退款！", "history.back()");
                        }

                        if (dr["status"].ToString() == "0")
                        {
                            Msg.AlertDoFun("对不起，未付款的订单无法申请退款！", "history.back()");
                        }
                    }
                }
            }
        }
    }
    private void DoSave()
    {
        string reason = KSCMS.S("Reason");

        Hashtable ht = new Hashtable();
        ht.Add("OrderID", dr["orderid"].ToString());
        ht.Add("UserID", dr["UserID"]);
        ht.Add("UserName", dr["username"].ToString());
        ht.Add("AddDate", DateTime.Now);
        ht.Add("Remark", reason);
        ht.Add("Money", Utils.StrToFloat(dr["MoneyReceipt"]).ToString("f2"));
        ht.Add("MoneyType", Utils.StrToInt(KSCMS.S("MoneyType")));
        ht.Add("BankCard", KSCMS.S("BankCard"));
        ht.Add("BankName", KSCMS.S("BankName"));
        ht.Add("CardName", KSCMS.S("CardName"));
        ht.Add("Status", 0);
        CommonData.Insert("[KS_CosOrderReturn]", ht);
        DataFactory.ExecuteNonQuery("UPDATE KS_CosOrder Set Status=3 Where id=" + id);

        int ReturnId = CommonData.GetMaxId("KS_CosOrderReturn", "ID");
        #region 产生订单记录,申请退款
        ht.Clear();
        ht.Add("UserName", new TemporaryVar().UserName);
        ht.Add("Inputer", "system");
        ht.Add("LogID", ReturnId);
        ht.Add("AddDate", DateTime.Now);
        ht.Add("Remark", "退款申请成功,请等待管理员确认！");
        Kesion.Course.Course.InsertOrderLog(dr["orderId"].ToString(), 11, ht);
        #endregion

        using(DataTable dtOrderItem=DataFactory.GetDataTable("SELECT CourseID From KS_CosOrderItem Where OrderID='"+dr["OrderID"].ToString()+"' And UserID="+__userinfo.UserID))
        {
            if (dtOrderItem.Rows.Count > 0)
            {
                foreach(DataRow drOrderItem in dtOrderItem.Rows)
                {
                    //Utils.WriteLog("mmmm");
                    //string sql = "select top 1 o.ID FROM KS_CosOrder o inner join KS_CosOrderItem i on o.OrderID=i.OrderID where o.Status=1 and o.OrderFlag=1 and i.CourseID="+Utils.StrToInt(drOrderItem["CourseID"].ToString())+" and i.OrderID!='2018121121265450'  and i.UserID=117876 and i.OrderType=0";
                    using (DataTable dt = DataFactory.GetDataTable("select top 1 id From  KS_CosOrder where status=1 and OrderFlag=0  and orderid in(select orderid from KS_CosOrderItem  where OrderID!='" + dr["OrderID"].ToString() + "' and userid=" + __userinfo.UserID + " and courseid=" + Utils.StrToInt(drOrderItem["CourseID"].ToString()) + " and ordertype=0)"))
                    {
                        if(dt.Rows.Count<=0)
                        {

                            Kesion.Course.CourseBuyRecordCache.DeleteUserPayCousreJson(__userinfo.UserID, Utils.StrToInt(drOrderItem["CourseID"].ToString()));                //清除购买记录
                            Kesion.Course.CourseLearnRecordCache.DeleteUserLearnRecordFromDB(__userinfo.UserID, Utils.StrToInt(drOrderItem["CourseID"].ToString()));          //学除学习记录

                        }

                    }


                }
            }
        }
        Msg.Alert("恭喜，申请退款成功,请等待处理!", BasicField.GetUserUrl("Course/MyCourseOrder"));
        return;


    }
</script>
<%
    if (!isLoadPage) return;
%>
<div class="r_tybox  t_tybox  nomar">
    <div class="r_title r_title_back  tytitle"> <h4><i class="userfont uf-back1" onclick="window.history.back(-1)"></i>退款申请</h4></div>

    <form name="myform" action="{$GetCurrUrl}" method="post" id="myform" >
        <input type="hidden" name="do" id="do" value="dosave" />
        <input type="hidden" name="flag" value="<%=flag %>" />
        <input type="hidden" name="ordertype" value="<%=ordertype %>" />
        <table class="border border-left" width="98%" align="center" border="0">

            <tr class="tdbg">
                <td class="lefttd" align="right" style="width: 100px;">订单编号：</td>
                <td><%=dr["orderid"].ToString() %>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="lefttd" align="right">退款金额：</td>
                <td style="height: 30px">
                    <span style="font-weight: bold; font-size: 16px; color: green"><%=MyCache.GetCurrencySymbol%><%=Utils.StrToFloat(dr["MoneyReceipt"]).ToString("f2") %></span> <%=MyCache.GetCurrencyUnit%>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="lefttd" align="right">退款原因：</td>
                <td>
                    <textarea name="Reason" id="Reason" style="width: 95%; height: 200px;"></textarea>
                    <%Kesion.APPCode.EditorAPI.EchoHead(); %>
                    <%Kesion.APPCode.EditorAPI.EchoEditor("editor", "Reason", "Basic", 0, false, true, true, false);%>
                </td>
            </tr>
            <tr class="tdbg" id="moneytype" runat="server">
                <td class="lefttd" align="right">退款方式：</td>
                <td>
<%--                    <asp:RadioButtonList ID="RdbReturnMoneyType" runat="server">
                        <asp:ListItem Value="1" Selected="True">账户余额</asp:ListItem>
                        <asp:ListItem Value="2">银行帐号</asp:ListItem>
                        <asp:ListItem Value="3">原路退回</asp:ListItem>
                    </asp:RadioButtonList>--%>
                    <input class="radio" name="MoneyType" type="radio" value="1" checked/>账户余额<br />
                    <input class="radio" name="MoneyType" type="radio" value="2" />银行帐号<br />
                    <input class="radio" name="MoneyType" type="radio" value="3" />原路退回(只支持微信付款）
                </td>
            </tr>

            <tbody id="returnbank" style="display: none">
                <tr class="tdbg">
                    <td class="lefttd" align="right">银行卡信息：</td>
                    <td>银行名称：<input type="text" name="BankName" id="BankName" maxlength="100" width="200" class="textbox">
                        <span class="tips">如中国工商银行某某分理处。</span>
                        <br />
                        银行卡号：<input type="text" name="BankCard" id="BankCard" maxlength="100" width="200" class="textbox">
                        <span class="tips">请正确填写银行卡号。</span>
                        <br />
                        银行户名：<input type="text" name="CardName" id="CardName" maxlength="100" width="200" class="textbox">
                        <span class="tips">请正确填写银行卡户主。</span>

                    </td>
                </tr>
            </tbody>

            <tr class="tdbg">
                <td></td>
                <td style="height: 50px;">
                    <input type="submit" id="BtnNext" onclick="return (checkform());" class="button" value="确定申请" /></td>
            </tr>
        </table>
    </form>
</div>
<script>
    $(function () {
        $(".radio").change(function () {
            showbank();
        })
    });
    function checkform() {
        if (editor.hasContents() == false) {
            KesionJS.Alert('请输入退款的原因！', "editor.focus(); ");
            return false;
        }

        var checkrad = $("input[name='MoneyType']:checked").val();
        if (checkrad == 2) {
            if ($("#BankName").val() == '') {
                KesionJS.Alert('请输入银行名称！', "$('#BankName').focus()");
                return false;
            }
            if ($("#BankCard").val() == '') {
                KesionJS.Alert('请输入银行卡号！', "$('#BankCard').focus()");
                return false;
            }
            if ($("#CardName").val() == '') {
                KesionJS.Alert('请输入银行卡号户名！', "$('#CardName').focus()");
                return false;
            }
        }
    }
    function showbank() {
        var checkrad = $("input[name='MoneyType']:checked").val();
        if (checkrad == 2) {
            $("#returnbank").show();
        } else {
            $("#returnbank").hide();
        }
    }
</script>
